/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import com.google.gson.JsonObject;
import io.github.reserveword.imblocker.IMBlocker;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.accessor.ModLoaderAccessor;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3518;

@Environment(value=EnvType.CLIENT)
public class ModLoaderAccessorImpl
implements ModLoaderAccessor {
    private static final int currentProtocolVersion;

    private ModLoaderAccessorImpl() {
    }

    @Override
    public boolean isGameVersionReached(int protocolVersion) {
        return currentProtocolVersion >= protocolVersion;
    }

    @Override
    public boolean hasMod(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    @Override
    public ModLoaderAccessor.Mapping getMapping() {
        return ModLoaderAccessor.Mapping.YARN;
    }

    @Override
    public void registerClientTickEvent(Runnable tickEvent) {
        ClientTickEvents.START_CLIENT_TICK.register(client -> tickEvent.run());
    }

    static {
        int protocolVersion;
        try (InputStream is = IMBlocker.class.getResourceAsStream("/version.json");
             InputStreamReader isr = new InputStreamReader(is);){
            protocolVersion = class_3518.method_15260((JsonObject)class_3518.method_15255((Reader)isr), (String)"protocol_version");
        }
        catch (Exception e) {
            IMBlockerCore.LOGGER.warn("[IMBlocker] Failed to get protocol version!");
            protocolVersion = Integer.MAX_VALUE;
        }
        currentProtocolVersion = protocolVersion;
    }
}

