/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin;

import io.github.reserveword.imblocker.common.IMBlockerConfig;
import io.github.reserveword.imblocker.common.IMBlockerCore;
import io.github.reserveword.imblocker.common.gui.FocusContainer;
import io.github.reserveword.imblocker.common.gui.FocusManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin {
    @Shadow
    private class_1041 field_1704;
    @Unique
    private long lastGameRenderTime = 0L;

    @Inject(method={"onWindowFocusChanged"}, at={@At(value="HEAD")})
    public void onWindowFocusChanged(boolean focused, CallbackInfo ci) {
        FocusManager.setWindowFocused(focused);
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")})
    public void onScreenChanged(class_437 screen, CallbackInfo ci) {
        if (IMBlockerConfig.INSTANCE.isScreenRecoveringEnabled() && screen != null) {
            IMBlockerConfig.INSTANCE.recoverScreen(screen.getClass().getName());
        }
        FocusContainer.MINECRAFT.clearFocus();
        FocusContainer.MINECRAFT.setPreferredState(this.isScreenInWhiteList(screen));
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    public void runPreRenderTasks(boolean tick, CallbackInfo ci) {
        IMBlockerCore.renderStart();
    }

    @Inject(method={"render"}, at={@At(value="CONSTANT", args={"stringValue=gameRenderer"})})
    public void recordGameRenderStartTime(boolean tick, CallbackInfo ci) {
        this.lastGameRenderTime = System.nanoTime();
        FocusManager.isGameRendering = true;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiler/Profiler;pop()V")})
    public void captureGameRenderEnd(boolean tick, CallbackInfo ci) {
        if (FocusManager.isGameRendering) {
            FocusManager.isGameRendering = false;
            FocusContainer.MINECRAFT.checkFocusCandidatesVisibility(this.lastGameRenderTime);
        }
    }

    private boolean isScreenInWhiteList(class_437 screen) {
        return IMBlockerConfig.INSTANCE.isScreenInWhitelist(screen);
    }
}

