/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Widget;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusableWidget;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Widget.class}, remap=false)
public abstract class FtbWidgetMixin
implements MinecraftFocusableWidget {
    @Shadow
    protected Panel parent;
    @Shadow
    public int posX;
    @Shadow
    public int posY;
    @Shadow
    public int width;
    @Shadow
    public int height;

    @Inject(method={"onClosed"}, at={@At(value="TAIL")})
    public void cancelFocus(CallbackInfo ci) {
    }

    @Inject(method={"setX"}, at={@At(value="TAIL")})
    public void handleXChanged(int x, CallbackInfo ci) {
        this.handleBoundsChanged();
    }

    @Inject(method={"setY"}, at={@At(value="TAIL")})
    public void handleYChanged(int y, CallbackInfo ci) {
        this.handleBoundsChanged();
    }

    @Inject(method={"setWidth"}, at={@At(value="TAIL")})
    public void handleWidthChanged(int x, CallbackInfo ci) {
        this.handleBoundsChanged();
    }

    @Inject(method={"setHeight"}, at={@At(value="TAIL")})
    public void handleHeightChanged(int y, CallbackInfo ci) {
        this.handleBoundsChanged();
    }

    public void handleBoundsChanged() {
    }

    @Unique
    public int getAbsoluteX() {
        int x = this.posX;
        Panel p = this.parent;
        while (p != null) {
            x += p.posX;
            p = ((FtbWidgetMixin)p).parent;
        }
        return x;
    }

    @Unique
    public int getAbsoluteY() {
        int y = this.posY;
        Panel p = this.parent;
        while (p != null) {
            y += p.posY;
            p = ((FtbWidgetMixin)p).parent;
        }
        return y;
    }

    @Override
    public Rectangle getBoundsAbs() {
        return new Rectangle(this.getGuiScale(), this.getAbsoluteX(), this.getAbsoluteY(), this.width, this.height);
    }
}

