/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker.mixin.compat;

import io.github.cottonmc.cotton.gui.client.CottonClientScreen;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.reserveword.imblocker.common.ReflectionUtil;
import io.github.reserveword.imblocker.common.accessor.MinecraftClientAccessor;
import io.github.reserveword.imblocker.common.gui.MinecraftFocusableWidget;
import io.github.reserveword.imblocker.common.gui.Rectangle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(value={WWidget.class}, remap=false)
public abstract class LibGuiWidgetMixin
implements MinecraftFocusableWidget {
    @Shadow
    protected int width;
    @Shadow
    protected int height;

    @Shadow
    protected abstract int getAbsoluteX();

    @Shadow
    protected abstract int getAbsoluteY();

    @Inject(method={"onFocusLost"}, at={@At(value="TAIL")})
    public void onFocusLost(CallbackInfo ci) {
    }

    @Inject(method={"setLocation"}, at={@At(value="TAIL")})
    public void handleLocationChanged(int x, int y, CallbackInfo ci) {
    }

    @Inject(method={"setSize"}, at={@At(value="TAIL")})
    public void handleSizeChanged(int width, int height, CallbackInfo ci) {
    }

    @Override
    public Rectangle getBoundsAbs() {
        int x = this.getAbsoluteX();
        int y = this.getAbsoluteY();
        Object currentScreen = MinecraftClientAccessor.INSTANCE.getCurrentScreen();
        if (CottonClientScreen.class.isInstance(currentScreen)) {
            x += ReflectionUtil.getFieldValue(CottonClientScreen.class, currentScreen, Integer.TYPE, "left").intValue();
            y += ReflectionUtil.getFieldValue(CottonClientScreen.class, currentScreen, Integer.TYPE, "top").intValue();
        }
        return new Rectangle(this.getGuiScale(), x, y, this.width, this.height);
    }
}

