/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.utils.BlockInfo;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class InfoCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"info").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandInfo))).then(class_2170.method_9247((String)"block").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"block position", (ArgumentType)class_2262.method_9698()).executes(c -> InfoCommand.infoBlock((class_2168)c.getSource(), class_2262.method_9697((CommandContext)c, (String)"block position"), null))).then(class_2170.method_9247((String)"grep").then(class_2170.method_9244((String)"regexp", (ArgumentType)StringArgumentType.greedyString()).executes(c -> InfoCommand.infoBlock((class_2168)c.getSource(), class_2262.method_9697((CommandContext)c, (String)"block position"), StringArgumentType.getString((CommandContext)c, (String)"regexp")))))));
        dispatcher.register(command);
    }

    public static void printBlock(List<class_2561> messages, class_2168 source, String grep) {
        Messenger.m(source, "");
        if (grep != null) {
            Pattern p = Pattern.compile(grep);
            Messenger.m(source, messages.get(0));
            for (int i = 1; i < messages.size(); ++i) {
                class_2561 line = messages.get(i);
                Matcher m = p.matcher(line.getString());
                if (!m.find()) continue;
                Messenger.m(source, line);
            }
        } else {
            Messenger.send(source, messages);
        }
    }

    private static int infoBlock(class_2168 source, class_2338 pos, String grep) {
        if (!source.method_9259(2)) {
            if (!source.method_9225().method_22340(pos)) {
                Messenger.m(source, "r Chunk is not loaded");
                return 0;
            }
            if (!source.method_9225().method_24794(pos)) {
                Messenger.m(source, "r Position is outside of world bounds");
                return 0;
            }
        }
        InfoCommand.printBlock(BlockInfo.blockInfo(pos, source.method_9225()), source, grep);
        return 1;
    }
}

