/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetSettings;
import carpet.logging.logHelpers.ExplosionLogHelper;
import carpet.mixins.ExplosionAccessor;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import org.apache.commons.lang3.tuple.Pair;

public class OptimizedExplosion {
    private static Object2DoubleOpenHashMap<Pair<class_243, class_238>> densityCache = new Object2DoubleOpenHashMap();
    private static Object2ObjectOpenHashMap<class_2338, class_2680> stateCache = new Object2ObjectOpenHashMap();
    private static Object2ObjectOpenHashMap<class_2338, class_3610> fluidCache = new Object2ObjectOpenHashMap();
    private static class_2338.class_2339 posMutable = new class_2338.class_2339(0, 0, 0);
    private static ObjectOpenHashSet<class_2338> affectedBlockPositionsSet = new ObjectOpenHashSet();
    private static boolean firstRay;
    private static boolean rayCalcDone;

    public static List<class_2338> doExplosionA(class_1927 e, ExplosionLogHelper eLogger) {
        List<class_2338> toBlow;
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        if (!CarpetSettings.explosionNoBlockDamage && eAccess.getDamageSource() != null) {
            rayCalcDone = false;
            firstRay = true;
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 0, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneY(e, 15, 0, 15, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 0, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneX(e, 15, 1, 14, 0, 15);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 0, 1, 14, 1, 14);
            OptimizedExplosion.getAffectedPositionsOnPlaneZ(e, 15, 1, 14, 1, 14);
            stateCache.clear();
            fluidCache.clear();
            toBlow = new ArrayList<class_2338>((Collection<class_2338>)affectedBlockPositionsSet);
            affectedBlockPositionsSet.clear();
        } else {
            toBlow = Collections.emptyList();
        }
        densityCache.clear();
        return toBlow;
    }

    private static void getAffectedPositionsOnPlaneX(class_1927 e, int x, int yStart, int yEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double xRel = (double)x / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneY(class_1927 e, int y, int xStart, int xEnd, int zStart, int zEnd) {
        if (!rayCalcDone) {
            double yRel = (double)y / 15.0 * 2.0 - 1.0;
            for (int z = zStart; z <= zEnd; ++z) {
                double zRel = (double)z / 15.0 * 2.0 - 1.0;
                for (int x = xStart; x <= xEnd; ++x) {
                    double xRel = (double)x / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static void getAffectedPositionsOnPlaneZ(class_1927 e, int z, int xStart, int xEnd, int yStart, int yEnd) {
        if (!rayCalcDone) {
            double zRel = (double)z / 15.0 * 2.0 - 1.0;
            for (int x = xStart; x <= xEnd; ++x) {
                double xRel = (double)x / 15.0 * 2.0 - 1.0;
                for (int y = yStart; y <= yEnd; ++y) {
                    double yRel = (double)y / 15.0 * 2.0 - 1.0;
                    if (!OptimizedExplosion.checkAffectedPosition(e, xRel, yRel, zRel)) continue;
                    return;
                }
            }
        }
    }

    private static boolean checkAffectedPosition(class_1927 e, double xRel, double yRel, double zRel) {
        ExplosionAccessor eAccess = (ExplosionAccessor)e;
        double len = Math.sqrt(xRel * xRel + yRel * yRel + zRel * zRel);
        double xInc = xRel / len * 0.3;
        double yInc = yRel / len * 0.3;
        double zInc = zRel / len * 0.3;
        float rand = eAccess.getLevel().field_9229.method_43057();
        float sizeRand = CarpetSettings.tntRandomRange >= 0.0 ? (float)CarpetSettings.tntRandomRange : rand;
        class_243 vec3 = eAccess.getCenter();
        double posX = vec3.field_1352;
        double posY = vec3.field_1351;
        double posZ = vec3.field_1350;
        float f1 = 0.3f;
        for (float size = eAccess.getRadius() * (0.7f + sizeRand * 0.6f); size > 0.0f; size -= 0.22500001f) {
            posMutable.method_10102(posX, posY, posZ);
            class_2680 state = (class_2680)stateCache.get((Object)posMutable);
            class_3610 fluid = (class_3610)fluidCache.get((Object)posMutable);
            class_2338 posImmutable = null;
            if (state == null) {
                posImmutable = posMutable.method_10062();
                state = eAccess.getLevel().method_8320(posImmutable);
                stateCache.put((Object)posImmutable, (Object)state);
                fluid = eAccess.getLevel().method_8316(posImmutable);
                fluidCache.put((Object)posImmutable, (Object)fluid);
            }
            if (!state.method_26215()) {
                float resistance = Math.max(state.method_26204().method_9520(), fluid.method_15760());
                if (eAccess.getSource() != null) {
                    resistance = eAccess.getSource().method_5774(e, (class_1922)eAccess.getLevel(), (class_2338)posMutable, state, fluid, resistance);
                }
                size -= (resistance + 0.3f) * 0.3f;
            }
            if (size > 0.0f) {
                if (eAccess.getSource() == null || eAccess.getSource().method_5853(e, (class_1922)eAccess.getLevel(), (class_2338)posMutable, state, size)) {
                    affectedBlockPositionsSet.add((Object)(posImmutable != null ? posImmutable : posMutable.method_10062()));
                }
            } else if (firstRay) {
                rayCalcDone = true;
                return true;
            }
            firstRay = false;
            posX += xInc;
            posY += yInc;
            posZ += zInc;
        }
        return false;
    }
}

