/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class MobAI {
    private static Map<class_1299<?>, Set<TrackingType>> aiTrackers = new HashMap();

    public static void resetTrackers() {
        aiTrackers.clear();
    }

    public static boolean isTracking(class_1297 e, TrackingType type) {
        if (e.method_37908().method_8608()) {
            return false;
        }
        Set<TrackingType> currentTrackers = aiTrackers.get(e.method_5864());
        if (currentTrackers == null) {
            return false;
        }
        return currentTrackers.contains((Object)type);
    }

    public static void clearTracking(MinecraftServer server, class_1299<? extends class_1297> etype) {
        aiTrackers.remove(etype);
        for (class_3218 world : server.method_3738()) {
            for (class_1297 e : world.method_18198(etype, class_1297::method_16914)) {
                e.method_5880(false);
                e.method_5665(null);
            }
        }
    }

    public static void startTracking(class_1299<?> e, TrackingType type) {
        aiTrackers.putIfAbsent(e, Sets.newHashSet());
        aiTrackers.get(e).add(type);
    }

    public static Stream<String> availbleTypes(class_2168 source) {
        HashSet types = new HashSet();
        for (TrackingType type : TrackingType.values()) {
            types.addAll(type.types);
        }
        return types.stream().map(t -> source.method_30497().method_30530(class_7924.field_41266).method_10221(t).method_12832());
    }

    public static Stream<String> availableFor(class_1299<?> entityType) {
        HashSet<TrackingType> availableOptions = new HashSet<TrackingType>();
        for (TrackingType type : TrackingType.values()) {
            if (!type.types.contains(entityType)) continue;
            availableOptions.add(type);
        }
        return availableOptions.stream().map(t -> t.name().toLowerCase());
    }

    public static enum TrackingType {
        IRON_GOLEM_SPAWNING(Set.of(class_1299.field_6077)),
        BREEDING(Set.of(class_1299.field_6077));

        public final Set<class_1299<?>> types;

        private TrackingType(Set<class_1299<?>> applicableTypes) {
            this.types = applicableTypes;
        }
    }
}

