/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.materials.json.MaterialListJsonBase;
import fi.dy.masa.malilib.util.game.RecipeBookUtils;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_10295;
import net.minecraft.class_10297;
import net.minecraft.class_10298;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10355;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MaterialListJsonEntry {
    private static final AnsiLogger LOGGER = new AnsiLogger(MaterialListJsonEntry.class, true, true);
    private final List<MaterialListJsonBase> requirements = new ArrayList<MaterialListJsonBase>();
    private final class_6880<class_1792> inputItem;
    private final int total;
    private final Type type;
    private boolean hasOutput = false;
    private class_10298 primaryId;
    private HashMap<class_10298, List<class_1856>> recipeRequirements;
    private HashMap<class_10298, class_10355> recipeCategory;
    private HashMap<class_10298, RecipeBookUtils.Type> recipeTypes;

    private MaterialListJsonEntry(class_6880<class_1792> inputItem, int total, Type type) {
        this.inputItem = inputItem;
        this.total = total;
        this.type = type;
    }

    @Nullable
    public static MaterialListJsonEntry build(class_6880<class_1792> input, int total, List<RecipeBookUtils.Type> types, @Nullable class_6880<class_1792> prevItem) {
        class_310 mc = class_310.method_1551();
        if (input == null || mc.field_1687 == null) {
            return null;
        }
        if (types.isEmpty()) {
            return new MaterialListJsonEntry(input, total, Type.EMPTY);
        }
        class_1799 shadow = new class_1799(input);
        List lookup = RecipeBookUtils.getDisplayEntryFromRecipeBook((class_1799)shadow, types);
        if (lookup.isEmpty()) {
            return new MaterialListJsonEntry(input, total, Type.LAST);
        }
        int lookupCount = lookup.size();
        Type outType = lookupCount > 1 ? Type.MULTI : Type.ONE;
        Litematica.LOGGER.warn("MaterialListJsonEntry#build(): Found [{}] recipe(s) for item [{}]", (Object)lookupCount, (Object)input.method_55840());
        MaterialListJsonEntry result = new MaterialListJsonEntry(input, total, outType);
        result.recipeRequirements = new HashMap();
        result.recipeCategory = new HashMap();
        result.recipeTypes = new HashMap();
        result.hasOutput = true;
        Pair pair = (Pair)lookup.getFirst();
        class_10298 id = (class_10298)pair.getLeft();
        class_10297 entry = (class_10297)pair.getRight();
        class_10355 category = entry.comp_3265();
        RecipeBookUtils.Type type = RecipeBookUtils.Type.fromRecipeDisplay((class_10295)entry.comp_3263());
        class_10352 map = RecipeBookUtils.getMap((class_310)mc);
        List resultStacks = entry.method_64730(map);
        class_1799 resultStack = (class_1799)resultStacks.getFirst();
        int resultCount = resultStack.method_7947();
        if (entry.comp_3266().isPresent()) {
            List ingredients = (List)entry.comp_3266().get();
            result.recipeRequirements.put(id, ingredients);
            result.recipeCategory.put(id, category);
            result.recipeTypes.put(id, type);
            result.primaryId = id;
            HashMap<class_6880, Integer> ded = new HashMap<class_6880, Integer>();
            for (class_1856 ing : ingredients) {
                class_10302 display = ing.method_64673();
                class_1799 displayStack = display.method_64742(map);
                class_6880 itemEntry = displayStack.method_41409();
                if (prevItem != null && prevItem == itemEntry) {
                    Litematica.LOGGER.warn("MaterialListJsonEntry#build(): ingredient matches previous item [{}] ... Skipping", (Object)prevItem.method_55840());
                    continue;
                }
                LOGGER.warn("build(): ResultStack: [{}] // Result Count: [{}]", new Object[]{resultStack.toString(), resultCount});
                int adjustedTotal = total;
                if (total > resultCount) {
                    float adjusted = (float)total / (float)resultCount;
                    int floor = class_3532.method_15375((float)adjusted);
                    int diff = total - floor;
                    adjustedTotal = resultCount > 1 ? diff : total;
                    LOGGER.warn("build(): adjusted: [{}], floor: [{}], diff: [{}] // AdjustedTotal: [{}]", new Object[]{Float.valueOf(adjusted), floor, diff, adjustedTotal});
                }
                if (ded.containsKey(itemEntry)) {
                    int count2 = (Integer)ded.get(itemEntry) + adjustedTotal;
                    ded.put(itemEntry, count2);
                    continue;
                }
                ded.put(itemEntry, adjustedTotal);
            }
            Litematica.LOGGER.warn("MaterialListJsonEntry#build(): Found [{}] sub-materials(s) for item [{}]", (Object)ded.size(), (Object)input.method_55840());
            ded.forEach((key, count) -> result.requirements.add(new MaterialListJsonBase((class_6880<class_1792>)key, (int)count, input)));
        }
        return result;
    }

    public Type getType() {
        return this.type;
    }

    public class_6880<class_1792> getInputItem() {
        return this.inputItem;
    }

    public List<MaterialListJsonBase> getRequirements() {
        return this.requirements;
    }

    public class_10298 getPrimaryId() {
        return this.primaryId;
    }

    public HashMap<class_10298, List<class_1856>> getRecipeRequirements() {
        return this.recipeRequirements;
    }

    public HashMap<class_10298, class_10355> getRecipeCategory() {
        return this.recipeCategory;
    }

    public HashMap<class_10298, RecipeBookUtils.Type> getRecipeTypes() {
        return this.recipeTypes;
    }

    public boolean hasOutput() {
        return this.hasOutput;
    }

    public int getTotal() {
        return this.total;
    }

    public JsonElement toJson(class_6903<?> ops) {
        JsonObject obj = new JsonObject();
        obj.add("Item", (JsonElement)new JsonPrimitive(this.getInputItem().method_55840()));
        obj.add("Count", (JsonElement)new JsonPrimitive((Number)this.getTotal()));
        obj.add("Type", (JsonElement)new JsonPrimitive(this.type.name()));
        if (this.hasOutput()) {
            obj.add("PrimaryId", (JsonElement)new JsonPrimitive((Number)this.getPrimaryId().comp_3267()));
            obj.add("Recipes", (JsonElement)this.lookupResultsToJson(ops));
        }
        return obj;
    }

    private JsonArray lookupResultsToJson(class_6903<?> ops) {
        JsonArray arr = new JsonArray();
        for (class_10298 id : this.recipeRequirements.keySet()) {
            List<class_1856> requires = this.recipeRequirements.get(id);
            class_10355 category = this.recipeCategory.get(id);
            RecipeBookUtils.Type type = this.recipeTypes.get(id);
            JsonObject obj = new JsonObject();
            obj.add("NetworkId", (JsonElement)new JsonPrimitive((Number)id.comp_3267()));
            obj.add("Category", (JsonElement)new JsonPrimitive(RecipeBookUtils.getRecipeCategoryId((class_10355)category)));
            obj.add("Type", (JsonElement)new JsonPrimitive(type.name()));
            JsonArray itemArr = new JsonArray();
            for (class_1856 ing : requires) {
                itemArr.add((JsonElement)class_1856.field_46095.encodeStart(ops, (Object)ing).getPartialOrThrow());
            }
            obj.add("Ingredients", (JsonElement)itemArr);
            JsonArray outputArr = new JsonArray();
            for (MaterialListJsonBase jsonEntry : this.requirements) {
                outputArr.add(jsonEntry.toJson(ops));
            }
            obj.add("Requirements", (JsonElement)outputArr);
            arr.add((JsonElement)obj);
        }
        return arr;
    }

    public static enum Type {
        LAST,
        EMPTY,
        ONE,
        MULTI;

    }
}

