/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_9799;

@Environment(value=EnvType.CLIENT)
public class BufferAllocatorCache
implements AutoCloseable {
    protected static final List<class_11515> BLOCK_LAYERS = ChunkRenderLayers.BLOCK_RENDER_LAYERS;
    protected static final List<class_1921> RENDER_LAYERS = ChunkRenderLayers.RENDER_LAYERS;
    protected static final List<OverlayRenderType> TYPES = ChunkRenderLayers.TYPES;
    protected static final int EXPECTED_TOTAL_SIZE = BLOCK_LAYERS.stream().mapToInt(class_11515::method_72021).sum() + RENDER_LAYERS.stream().mapToInt(class_1921::method_22722).sum() + TYPES.stream().mapToInt(OverlayRenderType::getExpectedBufferSize).sum();
    private final ConcurrentHashMap<class_11515, class_9799> blockCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<class_1921, class_9799> layerCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, class_9799> overlayCache = new ConcurrentHashMap();
    private boolean clear = true;

    protected BufferAllocatorCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocateCache() {
        ConcurrentHashMap<Object, class_9799> concurrentHashMap;
        for (class_11515 class_115152 : BLOCK_LAYERS) {
            if (this.blockCache.containsKey(class_115152)) {
                this.blockCache.get(class_115152).close();
            }
            concurrentHashMap = this.blockCache;
            synchronized (concurrentHashMap) {
                this.blockCache.put(class_115152, new class_9799(class_115152.method_72021()));
            }
        }
        for (class_1921 class_19212 : RENDER_LAYERS) {
            if (this.layerCache.containsKey(class_19212)) {
                this.layerCache.get(class_19212).close();
            }
            concurrentHashMap = this.layerCache;
            synchronized (concurrentHashMap) {
                this.layerCache.put(class_19212, new class_9799(class_19212.method_22722()));
            }
        }
        for (OverlayRenderType overlayRenderType : TYPES) {
            if (this.overlayCache.containsKey((Object)overlayRenderType)) {
                this.overlayCache.get((Object)overlayRenderType).close();
            }
            concurrentHashMap = this.overlayCache;
            synchronized (concurrentHashMap) {
                this.overlayCache.put(overlayRenderType, new class_9799(overlayRenderType.getExpectedBufferSize()));
            }
        }
        this.clear = true;
    }

    protected boolean hasBufferByBlockLayer(class_11515 layer) {
        return this.blockCache.containsKey(layer);
    }

    protected boolean hasBufferByLayer(class_1921 layer) {
        return this.layerCache.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(OverlayRenderType type) {
        return this.overlayCache.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected class_9799 getBufferByBlockLayer(class_11515 layer) {
        this.clear = false;
        ConcurrentHashMap<class_11515, class_9799> concurrentHashMap = this.blockCache;
        synchronized (concurrentHashMap) {
            return this.blockCache.computeIfAbsent(layer, l -> new class_9799(l.method_72021()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected class_9799 getBufferByLayer(class_1921 layer) {
        this.clear = false;
        ConcurrentHashMap<class_1921, class_9799> concurrentHashMap = this.layerCache;
        synchronized (concurrentHashMap) {
            return this.layerCache.computeIfAbsent(layer, l -> new class_9799(l.method_22722()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected class_9799 getBufferByOverlay(OverlayRenderType type) {
        this.clear = false;
        ConcurrentHashMap<OverlayRenderType, class_9799> concurrentHashMap = this.overlayCache;
        synchronized (concurrentHashMap) {
            return this.overlayCache.computeIfAbsent(type, t -> new class_9799(t.getExpectedBufferSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByBlockLayer(class_11515 layer) {
        try {
            ConcurrentHashMap<class_11515, class_9799> concurrentHashMap = this.blockCache;
            synchronized (concurrentHashMap) {
                this.blockCache.remove(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByLayer(class_1921 layer) {
        try {
            ConcurrentHashMap<class_1921, class_9799> concurrentHashMap = this.layerCache;
            synchronized (concurrentHashMap) {
                this.layerCache.remove(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByType(OverlayRenderType type) {
        try {
            ConcurrentHashMap<OverlayRenderType, class_9799> concurrentHashMap = this.overlayCache;
            synchronized (concurrentHashMap) {
                this.overlayCache.remove((Object)type).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean isClear() {
        return this.clear;
    }

    protected void resetAll() {
        try {
            this.blockCache.values().forEach(class_9799::method_60811);
            this.layerCache.values().forEach(class_9799::method_60811);
            this.overlayCache.values().forEach(class_9799::method_60811);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear = true;
    }

    protected void clearAll() {
        try {
            this.blockCache.values().forEach(class_9799::method_60809);
            this.layerCache.values().forEach(class_9799::method_60809);
            this.overlayCache.values().forEach(class_9799::method_60809);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clear = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAll() {
        ArrayList<class_9799> allocators;
        ConcurrentHashMap<Object, class_9799> concurrentHashMap = this.blockCache;
        synchronized (concurrentHashMap) {
            allocators = new ArrayList<class_9799>(this.blockCache.values());
            this.blockCache.clear();
        }
        concurrentHashMap = this.layerCache;
        synchronized (concurrentHashMap) {
            allocators.addAll(this.layerCache.values());
            this.layerCache.clear();
        }
        concurrentHashMap = this.overlayCache;
        synchronized (concurrentHashMap) {
            allocators.addAll(this.overlayCache.values());
            this.overlayCache.clear();
        }
        allocators.forEach(class_9799::close);
        this.clear = true;
    }

    @Override
    public void close() {
        this.closeAll();
    }
}

