/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.te;

import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_3218;

public class InfoLineFurnaceExp
extends InfoLine {
    private static final String FURNACE_KEY = "minihud.info_line.furnace_xp";

    public InfoLineFurnaceExp(InfoToggle type) {
        super(type);
    }

    public InfoLineFurnaceExp() {
        this(InfoToggle.FURNACE_XP);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasNbt()) {
            class_2591 beType = NbtBlockUtils.getBlockEntityTypeFromNbt((class_2487)ctx.nbt());
            if (beType == null) {
                return null;
            }
            return this.parseNbt(ctx.world(), beType, ctx.nbt());
        }
        return ctx.be() != null ? this.parseBlockEnt(ctx.world(), ctx.be()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseNbt(@Nonnull class_1937 world, @Nonnull class_2591<?> beType, @Nonnull class_2487 nbt) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (beType.equals((Object)class_2591.field_11903) || beType.equals((Object)class_2591.field_16415) || beType.equals((Object)class_2591.field_16414)) {
            int exp;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                int exp2 = MiscUtils.getFurnaceXpAmount(serverWorld, nbt);
                if (exp2 > 0) {
                    list.add(this.translate(FURNACE_KEY, exp2));
                }
            } else if (this.getHudData().hasServuxServer() && this.getHudData().hasRecipes() && (exp = MiscUtils.getFurnaceXpAmount(nbt)) > 0) {
                list.add(this.translate(FURNACE_KEY, exp));
            }
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseBlockEnt(@Nonnull class_1937 world, @Nonnull class_2586 be) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (be instanceof class_2609) {
            int exp;
            class_2609 furnace = (class_2609)be;
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                int exp2 = MiscUtils.getFurnaceXpAmount(serverWorld, furnace);
                if (exp2 > 0) {
                    list.add(this.translate(FURNACE_KEY, exp2));
                }
            } else if (this.getHudData().hasServuxServer() && this.getHudData().hasRecipes() && (exp = MiscUtils.getFurnaceXpAmount(furnace)) > 0) {
                list.add(this.translate(FURNACE_KEY, exp));
            }
        }
        return list;
    }
}

