/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_9801;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase
implements AutoCloseable {
    public static final OverlayRendererSpawnChunks INSTANCE_PLAYER = new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER);
    public static final OverlayRendererSpawnChunks INSTANCE_REAL = new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL);
    protected final RendererToggle toggle;
    protected final boolean isPlayerFollowing;
    protected boolean needsUpdate = true;
    protected List<class_238> boxesBrown;
    protected List<class_238> boxesRed;
    protected List<class_238> boxesYellow;
    protected List<class_238> boxesGreen;
    protected class_2338 center;
    private boolean hasData;

    protected OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
        this.isPlayerFollowing = toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER;
        this.boxesBrown = new ArrayList<class_238>();
        this.boxesRed = new ArrayList<class_238>();
        this.boxesYellow = new ArrayList<class_238>();
        this.boxesGreen = new ArrayList<class_238>();
        this.center = class_2338.field_10980;
        this.hasData = false;
    }

    @Override
    public String getName() {
        return "SpawnChunks";
    }

    public void setNeedsUpdate() {
        this.needsUpdate = true;
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        return this.toggle.getBooleanValue() && (this.isPlayerFollowing || mc.field_1687 != null && MiscUtils.isOverworld((class_1937)mc.field_1687) && HudDataManager.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(class_1297 entity, class_310 mc) {
        if (this.needsUpdate) {
            return true;
        }
        if (mc.field_1724 == null) {
            return false;
        }
        Object object = entity = this.isPlayerFollowing ? mc.field_1724 : entity;
        if (this.lastUpdatePos == null) {
            this.lastUpdatePos = entity.method_24515();
            return true;
        }
        int ex = (int)Math.floor(entity.method_23317());
        int ey = (int)Math.floor(entity.method_23318());
        int ez = (int)Math.floor(entity.method_23321());
        int lx = this.lastUpdatePos.method_10263();
        int ly = this.lastUpdatePos.method_10264();
        int lz = this.lastUpdatePos.method_10260();
        if (this.isPlayerFollowing) {
            return ex != lx || ez != lz || Math.abs(ey - ly) > 16;
        }
        int range = (Integer)mc.field_1690.method_42503().method_41753() * 16;
        return Math.abs(lx - ex) > range || Math.abs(ey - ly) > 16 || Math.abs(lz - ez) > range;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        Pair<class_2338, class_2338> corners;
        boolean yellowEnabled;
        boolean brownEnabled;
        int brown;
        int green;
        int yellow;
        int red;
        if (mc.field_1687 == null || mc.field_1724 == null || !RenderSystem.isOnRenderThread()) {
            return;
        }
        entity = this.isPlayerFollowing ? mc.field_1724 : entity;
        HudDataManager data = HudDataManager.getInstance();
        if (this.isPlayerFollowing) {
            this.center = PositionUtils.getEntityBlockPos((class_1297)entity);
            int spawnChunkRadius = this.getSimulationDistance();
            red = spawnChunkRadius + 1;
            yellow = spawnChunkRadius;
            green = spawnChunkRadius - 1;
            brown = red + 11;
            brownEnabled = Configs.Generic.SPAWN_PLAYER_OUTER_OVERLAY_ENABLED.getBooleanValue();
            yellowEnabled = Configs.Generic.SPAWN_PLAYER_REDSTONE_OVERLAY_ENABLED.getBooleanValue();
        } else {
            this.center = data.getWorldSpawn();
            int spawnChunkRadius = data.getSpawnChunkRadius();
            if (spawnChunkRadius < 0) {
                spawnChunkRadius = this.getSpawnChunkRadius((MinecraftServer)mc.method_1576());
                data.setSpawnChunkRadiusIfUnknown(spawnChunkRadius);
            }
            if (spawnChunkRadius < 0) {
                spawnChunkRadius = 2;
            }
            if (spawnChunkRadius == 0) {
                MiniHUD.LOGGER.warn("overlaySpawnChunkReal: toggling feature OFF since SPAWN_CHUNK_RADIUS is set to 0 (Nothing to render)");
                RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL.setBooleanValue(false);
                this.needsUpdate = false;
                return;
            }
            red = spawnChunkRadius + 1;
            yellow = spawnChunkRadius;
            green = spawnChunkRadius - 1;
            brown = red + 11;
            brownEnabled = Configs.Generic.SPAWN_REAL_OUTER_OVERLAY_ENABLED.getBooleanValue();
            yellowEnabled = Configs.Generic.SPAWN_REAL_REDSTONE_OVERLAY_ENABLED.getBooleanValue();
        }
        if (brownEnabled) {
            corners = this.getSpawnChunkCorners(this.center, brown, (class_1937)mc.field_1687);
            this.boxesBrown = RenderUtils.calculateBoxes((class_2338)corners.getLeft(), (class_2338)corners.getRight());
        }
        corners = this.getSpawnChunkCorners(this.center, red, (class_1937)mc.field_1687);
        this.boxesRed = RenderUtils.calculateBoxes((class_2338)corners.getLeft(), (class_2338)corners.getRight());
        if (yellowEnabled) {
            corners = this.getSpawnChunkCorners(this.center, yellow, (class_1937)mc.field_1687);
            this.boxesYellow = RenderUtils.calculateBoxes((class_2338)corners.getLeft(), (class_2338)corners.getRight());
        }
        corners = this.getSpawnChunkCorners(this.center, green, (class_1937)mc.field_1687);
        this.boxesGreen = RenderUtils.calculateBoxes((class_2338)corners.getLeft(), (class_2338)corners.getRight());
        this.hasData = true;
        this.render(cameraPos, mc, profiler);
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && !this.boxesGreen.isEmpty() && this.center != null;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers();
        this.renderQuads(cameraPos, mc, profiler);
        this.renderOutlines(cameraPos, mc, profiler);
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("spawn_chunk_quads");
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorRedstone = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_REDSTONE_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:spawn_chunk/quads", MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((class_2338)this.center, (class_243)cameraPos, (Color4f)colorEntity, (double)0.001, (class_287)builder);
        for (class_238 entry : this.boxesBrown) {
            RenderUtils.renderWallQuads(entry, cameraPos, colorOuter, builder);
        }
        for (class_238 entry : this.boxesRed) {
            RenderUtils.renderWallQuads(entry, cameraPos, colorLazy, builder);
        }
        for (class_238 entry : this.boxesYellow) {
            RenderUtils.renderWallQuads(entry, cameraPos, colorRedstone, builder);
        }
        for (class_238 entry : this.boxesGreen) {
            RenderUtils.renderWallQuads(entry, cameraPos, colorEntity, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnChunks#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("spawn_chunk_outlines");
        Color4f colorEntity = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getColor();
        Color4f colorRedstone = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_REDSTONE_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_REDSTONE_OVERLAY_COLOR.getColor();
        Color4f colorLazy = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getColor();
        Color4f colorOuter = this.isPlayerFollowing ? Configs.Colors.SPAWN_PLAYER_OUTER_OVERLAY_COLOR.getColor() : Configs.Colors.SPAWN_REAL_OUTER_OVERLAY_COLOR.getColor();
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:spawn_chunk/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((class_2338)this.center, (class_243)cameraPos, (Color4f)Color4f.WHITE, (double)0.001, (class_287)builder);
        for (class_238 entry : this.boxesBrown) {
            RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorOuter, builder);
        }
        for (class_238 entry : this.boxesRed) {
            RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorLazy, builder);
        }
        for (class_238 entry : this.boxesYellow) {
            RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorRedstone, builder);
        }
        for (class_238 entry : this.boxesGreen) {
            RenderUtils.renderWallOutlines(entry, 16.0, 16.0, true, cameraPos, colorEntity, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererSpawnChunks#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.boxesBrown.clear();
        this.boxesRed.clear();
        this.boxesYellow.clear();
        this.boxesGreen.clear();
        this.center = null;
        this.hasData = false;
    }

    @Override
    public void close() {
        this.reset();
    }

    protected Pair<class_2338, class_2338> getSpawnChunkCorners(class_2338 worldSpawn, int chunkRange, class_1937 world) {
        int cx = worldSpawn.method_10263() >> 4;
        int cz = worldSpawn.method_10260() >> 4;
        int minY = this.getMinY(world, worldSpawn, cx, cz);
        int maxY = world != null ? world.method_31600() + 1 : 320;
        class_2338 pos1 = new class_2338(cx - chunkRange << 4, minY, cz - chunkRange << 4);
        class_2338 pos2 = new class_2338((cx + chunkRange << 4) + 15, maxY, (cz + chunkRange << 4) + 15);
        return Pair.of((Object)pos1, (Object)pos2);
    }

    private int getMinY(class_1937 world, class_2338 pos, int cx, int cz) {
        int minY;
        class_310 mc = class_310.method_1551();
        if (world != null && mc.field_1724 != null) {
            int ws = world.method_8497(cx, cz).method_12005(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260());
            minY = mc.field_1724.method_24515().method_10264() >= world.method_8615() ? Math.min(world.method_8615(), ws) : Math.min(Math.max(world.method_32891(), ws), mc.field_1724.method_24515().method_10264() - 16);
        } else {
            minY = world != null ? world.method_31607() : -64;
        }
        return minY;
    }

    protected int getSpawnChunkRadius(@Nullable MinecraftServer server) {
        if (server != null) {
            return server.method_30002().method_64395().method_8356(class_1928.field_48374);
        }
        if (HudDataManager.getInstance().isSpawnChunkRadiusKnown()) {
            return HudDataManager.getInstance().getSpawnChunkRadius();
        }
        return 2;
    }

    protected int getSimulationDistance() {
        if (DataStorage.getInstance().isSimulationDistanceKnown()) {
            return DataStorage.getInstance().getSimulationDistance();
        }
        return 10;
    }
}

