/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_9801;

public class ShapeBox
extends ShapeBase {
    public static final class_238 DEFAULT_BOX = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final double MAX_DIMENSIONS = 10000.0;
    protected class_238 box = DEFAULT_BOX;
    protected class_238 renderPerimeter = DEFAULT_BOX;
    protected class_243 corner1 = class_243.field_1353;
    protected class_243 corner2 = class_243.field_1353;
    protected int enabledSidesMask = 63;
    protected double maxDimensions = 10000.0;
    protected boolean gridEnabled = true;
    protected class_243 gridSize = new class_243(16.0, 16.0, 16.0);
    protected class_243 gridStartOffset = class_243.field_1353;
    protected class_243 gridEndOffset = class_243.field_1353;
    private class_238 renderBox = null;
    private boolean hasData = false;

    public ShapeBox() {
        super(ShapeType.BOX, Configs.Colors.SHAPE_BOX.getColor());
        this.useCulling = true;
    }

    public class_238 getBox() {
        return this.box;
    }

    public int getEnabledSidesMask() {
        return this.enabledSidesMask;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public class_243 getGridSize() {
        return this.gridSize;
    }

    public class_243 getGridStartOffset() {
        return this.gridStartOffset;
    }

    public class_243 getGridEndOffset() {
        return this.gridEndOffset;
    }

    public class_243 getCorner1() {
        return this.corner1;
    }

    public class_243 getCorner2() {
        return this.corner2;
    }

    public void setCorner1(class_243 corner1) {
        this.corner1 = corner1;
        this.setBoxFromCorners();
    }

    public void setCorner2(class_243 corner2) {
        this.corner2 = corner2;
        this.setBoxFromCorners();
    }

    protected void setBoxFromCorners() {
        class_238 box = new class_238(this.corner1, this.corner2);
        this.box = this.clampBox(box, this.maxDimensions);
        double margin = (Integer)class_310.method_1551().field_1690.method_42503().method_41753() * 16 * 2;
        this.renderPerimeter = box.method_1014(margin);
        this.setNeedsUpdate();
    }

    protected class_238 clampBox(class_238 box, double maxSize) {
        if (Math.abs(box.field_1320 - box.field_1323) > maxSize || Math.abs(box.field_1325 - box.field_1322) > maxSize || Math.abs(box.field_1324 - box.field_1321) > maxSize) {
            box = DEFAULT_BOX;
        }
        return box;
    }

    public void setEnabledSidesMask(int enabledSidesMask) {
        this.enabledSidesMask = enabledSidesMask;
        this.setNeedsUpdate();
    }

    public void toggleGridEnabled() {
        this.gridEnabled = !this.gridEnabled;
        this.setNeedsUpdate();
    }

    public void setGridSize(class_243 gridSize) {
        double x = class_3532.method_15350((double)gridSize.field_1352, (double)0.5, (double)1024.0);
        double y = class_3532.method_15350((double)gridSize.field_1351, (double)0.5, (double)1024.0);
        double z = class_3532.method_15350((double)gridSize.field_1350, (double)0.5, (double)1024.0);
        this.gridSize = new class_243(x, y, z);
        this.setNeedsUpdate();
    }

    public void setGridStartOffset(class_243 gridStartOffset) {
        double x = class_3532.method_15350((double)gridStartOffset.field_1352, (double)0.0, (double)1024.0);
        double y = class_3532.method_15350((double)gridStartOffset.field_1351, (double)0.0, (double)1024.0);
        double z = class_3532.method_15350((double)gridStartOffset.field_1350, (double)0.0, (double)1024.0);
        this.gridStartOffset = new class_243(x, y, z);
        this.setNeedsUpdate();
    }

    public void setGridEndOffset(class_243 gridEndOffset) {
        double x = class_3532.method_15350((double)gridEndOffset.field_1352, (double)0.0, (double)1024.0);
        double y = class_3532.method_15350((double)gridEndOffset.field_1351, (double)0.0, (double)1024.0);
        double z = class_3532.method_15350((double)gridEndOffset.field_1350, (double)0.0, (double)1024.0);
        this.gridEndOffset = new class_243(x, y, z);
        this.setNeedsUpdate();
    }

    @Override
    public boolean shouldRender(class_310 mc) {
        class_1297 entity = EntityUtils.getCameraEntity();
        return super.shouldRender(mc) && entity != null && this.renderPerimeter.method_1006(entity.method_19538());
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        this.renderBox = this.box.method_989(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        this.hasData = true;
        this.render(cameraPos, mc, profiler);
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData && this.renderBox != null;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers(this.renderLines);
        this.renderBoxQuads(cameraPos, mc, profiler);
        if (this.renderLines) {
            this.renderBoxOutlines(cameraPos, mc, profiler);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.renderBox = null;
        this.hasData = false;
    }

    protected void renderBoxQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("box_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:box/quads", this.renderThroughShape ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET);
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        for (class_2350 side : PositionUtils.ALL_DIRECTIONS) {
            if (!ShapeBox.isSideEnabled(side, this.enabledSidesMask)) continue;
            ShapeBox.renderBoxSideQuad(this.renderBox, side, this.color, builder);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("ShapeBox#renderBoxQuads(): Exception; {}", (Object)err.getMessage());
        }
        matrices.method_22909();
        profiler.method_15407();
    }

    protected void renderBoxOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !this.renderLines) {
            return;
        }
        profiler.method_15396("box_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:box/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        class_4587 matrices = new class_4587();
        matrices.method_22903();
        class_4587.class_4665 e = matrices.method_23760();
        this.renderBoxEnabledEdgeLines(this.renderBox, this.colorLines, this.enabledSidesMask, builder, e);
        if (this.gridEnabled) {
            this.renderGridLines(this.renderBox, this.colorLines, builder, e);
        }
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererRegion#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        matrices.method_22909();
        profiler.method_15407();
    }

    protected void renderGridLines(class_238 box, Color4f color, class_287 builder, class_4587.class_4665 e) {
        if (ShapeBox.isSideEnabled(class_2350.field_11033, this.enabledSidesMask)) {
            this.renderGridLinesY(box, box.field_1322, color, builder, e);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11036, this.enabledSidesMask)) {
            this.renderGridLinesY(box, box.field_1325, color, builder, e);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11043, this.enabledSidesMask)) {
            this.renderGridLinesZ(box, box.field_1321, color, builder, e);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11035, this.enabledSidesMask)) {
            this.renderGridLinesZ(box, box.field_1324, color, builder, e);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11039, this.enabledSidesMask)) {
            this.renderGridLinesX(box, box.field_1323, color, builder, e);
        }
        if (ShapeBox.isSideEnabled(class_2350.field_11034, this.enabledSidesMask)) {
            this.renderGridLinesX(box, box.field_1320, color, builder, e);
        }
    }

    protected void renderGridLinesX(class_238 box, double x, Color4f color, class_287 buffer, class_4587.class_4665 e) {
        double end = box.field_1325 - this.gridEndOffset.field_1351;
        double min = box.field_1321 + this.gridStartOffset.field_1350;
        double max = box.field_1324 - this.gridEndOffset.field_1350;
        for (double y = box.field_1322 + this.gridStartOffset.field_1351; y <= end; y += this.gridSize.field_1351) {
            buffer.method_56824(e, (float)x, (float)y, (float)min).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, (float)x, (float)y, (float)max).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        end = box.field_1324 - this.gridEndOffset.field_1350;
        min = box.field_1322 + this.gridStartOffset.field_1351;
        max = box.field_1325 - this.gridEndOffset.field_1351;
        for (double z = box.field_1321 + this.gridStartOffset.field_1350; z <= end; z += this.gridSize.field_1350) {
            buffer.method_56824(e, (float)x, (float)min, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, (float)x, (float)max, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
    }

    protected void renderGridLinesY(class_238 box, double y, Color4f color, class_287 buffer, class_4587.class_4665 e) {
        double end = box.field_1320 - this.gridEndOffset.field_1352;
        double min = box.field_1321 + this.gridStartOffset.field_1350;
        double max = box.field_1324 - this.gridEndOffset.field_1350;
        for (double x = box.field_1323 + this.gridStartOffset.field_1352; x <= end; x += this.gridSize.field_1352) {
            buffer.method_56824(e, (float)x, (float)y, (float)min).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, (float)x, (float)y, (float)max).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        end = box.field_1324 - this.gridEndOffset.field_1350;
        min = box.field_1323 + this.gridStartOffset.field_1352;
        max = box.field_1320 - this.gridEndOffset.field_1352;
        for (double z = box.field_1321 + this.gridStartOffset.field_1350; z <= end; z += this.gridSize.field_1350) {
            buffer.method_56824(e, (float)min, (float)y, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, (float)max, (float)y, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
    }

    protected void renderGridLinesZ(class_238 box, double z, Color4f color, class_287 buffer, class_4587.class_4665 e) {
        double end = box.field_1320 - this.gridEndOffset.field_1352;
        double min = box.field_1322 + this.gridStartOffset.field_1351;
        double max = box.field_1325 - this.gridEndOffset.field_1351;
        for (double x = box.field_1323 + this.gridStartOffset.field_1352; x <= end; x += this.gridSize.field_1352) {
            buffer.method_56824(e, (float)x, (float)min, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, (float)x, (float)max, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        end = box.field_1325 - this.gridEndOffset.field_1351;
        min = box.field_1323 + this.gridStartOffset.field_1352;
        max = box.field_1320 - this.gridEndOffset.field_1352;
        for (double y = box.field_1322 + this.gridStartOffset.field_1351; y <= end; y += this.gridSize.field_1351) {
            buffer.method_56824(e, (float)min, (float)y, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, (float)max, (float)y, (float)z).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
    }

    public boolean isSideEnabled(class_2350 side) {
        return ShapeBox.isSideEnabled(side, this.enabledSidesMask);
    }

    public static boolean isSideEnabled(class_2350 side, int enabledSidesMask) {
        return (enabledSidesMask & 1 << side.method_10146()) != 0;
    }

    public static void renderBoxSideQuad(class_238 box, class_2350 side, Color4f color, class_287 buffer) {
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        switch (side) {
            case field_11033: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11036: {
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11043: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11035: {
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11039: {
                buffer.method_22912(minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                break;
            }
            case field_11034: {
                buffer.method_22912(maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a);
                buffer.method_22912(maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a);
            }
        }
    }

    protected void renderBoxEnabledEdgeLines(class_238 box, Color4f color, int enabledSidesMask, class_287 buffer, class_4587.class_4665 e) {
        boolean down = ShapeBox.isSideEnabled(class_2350.field_11033, enabledSidesMask);
        boolean up = ShapeBox.isSideEnabled(class_2350.field_11036, enabledSidesMask);
        boolean north = ShapeBox.isSideEnabled(class_2350.field_11043, enabledSidesMask);
        boolean south = ShapeBox.isSideEnabled(class_2350.field_11035, enabledSidesMask);
        boolean west = ShapeBox.isSideEnabled(class_2350.field_11039, enabledSidesMask);
        boolean east = ShapeBox.isSideEnabled(class_2350.field_11034, enabledSidesMask);
        float minX = (float)box.field_1323;
        float minY = (float)box.field_1322;
        float minZ = (float)box.field_1321;
        float maxX = (float)box.field_1320;
        float maxY = (float)box.field_1325;
        float maxZ = (float)box.field_1324;
        if (down || north) {
            buffer.method_56824(e, minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (up || north) {
            buffer.method_56824(e, minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (down || south) {
            buffer.method_56824(e, minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (up || south) {
            buffer.method_56824(e, minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (down || west) {
            buffer.method_56824(e, minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (up || west) {
            buffer.method_56824(e, minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (down || east) {
            buffer.method_56824(e, maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (up || east) {
            buffer.method_56824(e, maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (north || west) {
            buffer.method_56824(e, minX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, minX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (south || west) {
            buffer.method_56824(e, minX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, minX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (north || east) {
            buffer.method_56824(e, maxX, minY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, maxY, minZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
        if (south || east) {
            buffer.method_56824(e, maxX, minY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
            buffer.method_56824(e, maxX, maxY, maxZ).method_22915(color.r, color.g, color.b, color.a).method_60831(e, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        class_238 box = this.box;
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.box.min_corner", (Object[])new Object[]{box.field_1323, box.field_1322, box.field_1321}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.shape.box.max_corner", (Object[])new Object[]{box.field_1320, box.field_1325, box.field_1324}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.addProperty("enabled_sides", (Number)this.enabledSidesMask);
        obj.addProperty("grid_enabled", Boolean.valueOf(this.gridEnabled));
        obj.add("grid_size", (JsonElement)JsonUtils.vec3dToJson((class_243)this.gridSize));
        obj.add("grid_start_offset", (JsonElement)JsonUtils.vec3dToJson((class_243)this.gridStartOffset));
        obj.add("grid_end_offset", (JsonElement)JsonUtils.vec3dToJson((class_243)this.gridEndOffset));
        obj.add("corner1", (JsonElement)JsonUtils.vec3dToJson((class_243)this.corner1));
        obj.add("corner2", (JsonElement)JsonUtils.vec3dToJson((class_243)this.corner2));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.enabledSidesMask = JsonUtils.getIntegerOrDefault((JsonObject)obj, (String)"enabled_sides", (int)63);
        this.gridEnabled = JsonUtils.getBooleanOrDefault((JsonObject)obj, (String)"grid_enabled", (boolean)true);
        this.gridSize = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_size");
        this.gridStartOffset = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_start_offset");
        this.gridEndOffset = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"grid_end_offset");
        if (this.gridSize == null) {
            this.gridSize = new class_243(16.0, 16.0, 16.0);
        }
        if (this.gridStartOffset == null) {
            this.gridStartOffset = class_243.field_1353;
        }
        if (this.gridEndOffset == null) {
            this.gridEndOffset = class_243.field_1353;
        }
        class_243 corner1 = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"corner1");
        class_243 corner2 = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"corner2");
        if (corner1 != null && corner2 != null) {
            this.corner1 = corner1;
            this.corner2 = corner2;
        } else {
            double minX = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minX", (double)0.0);
            double minY = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minY", (double)0.0);
            double minZ = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"minZ", (double)0.0);
            double maxX = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxX", (double)0.0);
            double maxY = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxY", (double)0.0);
            double maxZ = JsonUtils.getDoubleOrDefault((JsonObject)obj, (String)"maxZ", (double)0.0);
            this.corner1 = new class_243(minX, minY, minZ);
            this.corner2 = new class_243(maxX, maxY, maxZ);
        }
        this.setBoxFromCorners();
    }
}

