/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.nbt;

import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import fi.dy.masa.malilib.util.nbt.NbtView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1258;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_4614;
import net.minecraft.class_5455;

public class NbtInventory
implements AutoCloseable {
    private static final AnsiLogger LOGGER = new AnsiLogger(NbtInventory.class, true, true);
    public static final int DEFAULT_SIZE = 27;
    public static final int DOUBLE_SIZE = 54;
    public static final int MAX_SIZE = 256;
    private HashSet<class_11343> items;

    private NbtInventory() {
    }

    public static NbtInventory create(int size) {
        NbtInventory newInv = new NbtInventory();
        size = class_3532.method_15340((int)size, (int)1, (int)256);
        newInv.buildEmptyList(size);
        return newInv;
    }

    private void buildEmptyList(int size) throws RuntimeException {
        if (this.items != null) {
            throw new RuntimeException("List not empty!");
        }
        this.items = new HashSet();
        for (int i = 0; i < size; ++i) {
            this.items.add(new class_11343(i, class_1799.field_8037));
        }
    }

    public boolean isEmpty() {
        if (this.items == null || this.items.isEmpty()) {
            return true;
        }
        AtomicBoolean bool = new AtomicBoolean(true);
        this.items.forEach(slot -> {
            if (!slot.comp_4212().method_7960()) {
                bool.set(false);
            }
        });
        return bool.get();
    }

    public int size() {
        if (this.items == null) {
            return -1;
        }
        return this.items.size();
    }

    public class_2371<class_1799> toVanillaList(int size) {
        if (this.isEmpty()) {
            return class_2371.method_10211();
        }
        size = Math.clamp((long)size, this.size(), 256);
        class_2371 list = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        AtomicInteger i = new AtomicInteger(0);
        this.items.forEach(slot -> {
            list.set(slot.comp_4211(), (Object)slot.comp_4212());
            i.getAndIncrement();
        });
        return list;
    }

    @Nullable
    public static NbtInventory fromVanillaList(@Nonnull class_2371<class_1799> list) {
        int size = list.size();
        if (size < 1) {
            return null;
        }
        size = class_3532.method_15340((int)size, (int)1, (int)256);
        NbtInventory newInv = new NbtInventory();
        newInv.items = new HashSet();
        for (int i = 0; i < size; ++i) {
            class_11343 slot = new class_11343(i, (class_1799)list.get(i));
            newInv.items.add(slot);
        }
        return newInv;
    }

    @Nullable
    public class_1263 toInventory(int size) {
        if (this.isEmpty()) {
            return null;
        }
        int sizeAdj = Math.clamp((long)size, this.size(), 256);
        Object inv = sizeAdj > 54 ? new class_1277(Math.clamp((long)size, this.size(), 256)) : (sizeAdj > 27 && sizeAdj < 54 ? new class_1258((class_1263)new class_1277(27), (class_1263)new class_1277(27)) : new class_1277(Math.clamp((long)size, this.size(), 27)));
        AtomicInteger i = new AtomicInteger(0);
        this.items.forEach(arg_0 -> NbtInventory.lambda$toInventory$2((class_1263)inv, i, arg_0));
        return inv;
    }

    public static NbtInventory fromInventory(@Nonnull class_1263 inv) {
        NbtInventory newInv = new NbtInventory();
        ArrayList<Integer> slotsUsed = new ArrayList<Integer>();
        int size = inv.method_5439();
        int maxSlot = 0;
        size = class_3532.method_15340((int)size, (int)1, (int)256);
        newInv.items = new HashSet();
        for (int i = 0; i < size; ++i) {
            class_11343 slot = new class_11343(i, inv.method_5438(i));
            newInv.items.add(slot);
            slotsUsed.add(slot.comp_4211());
            if (slot.comp_4211() <= maxSlot) continue;
            maxSlot = slot.comp_4211();
        }
        newInv.verifySize(slotsUsed, maxSlot);
        return newInv;
    }

    @Nullable
    public NbtView toNbtWriterView(@Nonnull class_5455 registry) {
        if (this.isEmpty()) {
            return null;
        }
        int size = Math.max(this.size(), 27);
        NbtView view = NbtView.getWriter(registry);
        class_2371<class_1799> list = this.toVanillaList(size);
        class_1262.method_5426((class_11372)Objects.requireNonNull(view.getWriter()), list);
        return view;
    }

    @Nullable
    public static NbtInventory fromNbtReaderView(@Nonnull NbtView view, int size) {
        if (size < 1) {
            return null;
        }
        size = class_3532.method_15340((int)size, (int)1, (int)256);
        class_2371 list = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
        class_1262.method_5429((class_11368)Objects.requireNonNull(view.getReader()), (class_2371)list);
        return NbtInventory.fromVanillaList((class_2371<class_1799>)list);
    }

    public class_2520 toNbtSingle(@Nonnull class_5455 registry) throws RuntimeException {
        if (this.size() > 1) {
            throw new RuntimeException("Inventory is too large for a single entry!");
        }
        class_11343 slot = (class_11343)this.items.stream().findFirst().orElseThrow();
        if (!slot.comp_4212().method_7960()) {
            class_2520 element = (class_2520)class_11343.field_60354.encodeStart((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)slot).getPartialOrThrow();
            return element;
        }
        return new class_2487();
    }

    public class_2499 toNbtList(@Nonnull class_5455 registry) throws RuntimeException {
        class_2499 nbt = new class_2499();
        if (this.isEmpty()) {
            return nbt;
        }
        this.items.forEach(slot -> {
            if (!slot.comp_4212().method_7960()) {
                class_2520 element = (class_2520)class_11343.field_60354.encodeStart((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), slot).getPartialOrThrow();
                nbt.add((Object)element);
            }
        });
        return nbt;
    }

    public class_2487 toNbt(class_4614<?> type, String key, @Nonnull class_5455 registry) throws RuntimeException {
        class_2487 nbt = new class_2487();
        if (type == class_2499.field_21039) {
            class_2499 list = this.toNbtList(registry);
            if (list.isEmpty()) {
                return nbt;
            }
            nbt.method_10566(key, (class_2520)list);
            return nbt;
        }
        if (type == class_2487.field_21029) {
            nbt.method_10566(key, this.toNbtSingle(registry));
            return nbt;
        }
        throw new RuntimeException("Unsupported Nbt Type!");
    }

    @Nullable
    public static NbtInventory fromNbt(@Nonnull class_2487 nbtIn, String key, boolean noSlotId, @Nonnull class_5455 registry) throws RuntimeException {
        if (nbtIn.method_33133() || !nbtIn.method_10545(key)) {
            return null;
        }
        if (Objects.requireNonNull(nbtIn.method_10580(key)).method_23258() == class_2499.field_21039) {
            return NbtInventory.fromNbtList(nbtIn.method_68569(key), noSlotId, registry);
        }
        if (Objects.requireNonNull(nbtIn.method_10580(key)).method_23258() == class_2487.field_21029) {
            return NbtInventory.fromNbtSingle(nbtIn.method_68568(key), registry);
        }
        throw new RuntimeException("Invalid Nbt Type!");
    }

    @Nullable
    public static NbtInventory fromNbtSingle(@Nonnull class_2487 nbt, @Nonnull class_5455 registry) throws RuntimeException {
        if (nbt.method_33133()) {
            return null;
        }
        NbtInventory newInv = new NbtInventory();
        newInv.items = new HashSet();
        class_11343 slot = (class_11343)class_11343.field_60354.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).getPartialOrThrow();
        newInv.items.add(slot);
        return newInv;
    }

    @Nullable
    public static NbtInventory fromNbtList(@Nonnull class_2499 list, boolean noSlotId, @Nonnull class_5455 registry) throws RuntimeException {
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 256) {
            throw new RuntimeException("Nbt List is too large!");
        }
        int size = list.size();
        size = class_3532.method_15340((int)size, (int)1, (int)256);
        NbtInventory newInv = new NbtInventory();
        ArrayList<Integer> slotsUsed = new ArrayList<Integer>();
        int maxSlot = 0;
        newInv.items = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            class_11343 slot = noSlotId ? new class_11343(i, (class_1799)class_1799.field_24671.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)((class_2520)list.get(i))).getPartialOrThrow()) : (class_11343)class_11343.field_60354.parse((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)((class_2520)list.get(i))).getPartialOrThrow();
            newInv.items.add(slot);
            slotsUsed.add(slot.comp_4211());
            if (slot.comp_4211() <= maxSlot) continue;
            maxSlot = slot.comp_4211();
        }
        newInv.verifySize(slotsUsed, maxSlot);
        return newInv;
    }

    private void verifySize(List<Integer> slotsUsed, int maxSlot) {
        int size = Math.max(this.size(), maxSlot);
        if (size > 8 && size <= 27) {
            size = 27;
        } else if (size > 27 && size < 54) {
            size = 54;
        } else if (size > 54 && size < 256) {
            size = 256;
        }
        for (int i = 0; i < size; ++i) {
            if (slotsUsed.contains(i)) continue;
            this.items.add(new class_11343(i, class_1799.field_8037));
        }
    }

    public void dumpInv() {
        AtomicInteger i = new AtomicInteger(0);
        LOGGER.info("dumpInv() --> START", new Object[0]);
        this.items.forEach(slot -> LOGGER.info("[{}]: slot [{}], stack: [{}]", i, slot.comp_4211(), slot.comp_4212().toString()));
        LOGGER.info("dumpInv() --> END", new Object[0]);
    }

    @Override
    public void close() throws Exception {
        this.items.clear();
    }

    private static /* synthetic */ void lambda$toInventory$2(class_1263 inv, AtomicInteger i, class_11343 slot) {
        inv.method_5447(slot.comp_4211(), slot.comp_4212());
        i.getAndIncrement();
    }
}

